/*
 * Decompiled with CFR 0.152.
 */
package com.tuoren.web.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tuoren.web.layer.entity.BusAnalgesicScoreEntity;
import com.tuoren.web.layer.entity.BusHospitalEntity;
import com.tuoren.web.layer.entity.BusPatientEntity;
import com.tuoren.web.layer.entity.BusPumpEntity;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;

public class ConverterUtils {
    public static Map<String, Properties> entityProperties = new HashMap<String, Properties>();

    private static void registerPump() {
        Properties properties = new Properties();
        properties.setProperty("pumpCode", "PumpCode");
        properties.setProperty("productCode", "SysProduct_ID");
        properties.setProperty("hospitalCode", "SysHospital_ID");
        properties.setProperty("patientCode", "PatientCode");
        properties.setProperty("remainQuantity", "BalanceQuantity");
        properties.setProperty("continueQuantity", "ContinueQuantity");
        properties.setProperty("selfControlQuantity", "SelfQuantity");
        properties.setProperty("lockTime", "LockTime");
        properties.setProperty("inputQuantity", "InputQuantity");
        properties.setProperty("validTime", "TrueNum");
        properties.setProperty("invalidTime", "FalseNum");
        properties.setProperty("maxQuantity", "MaxQuantity");
        properties.setProperty("firstQuantity", "FirstQuantity");
        properties.setProperty("singleQuantity", "SingleQuantity");
        properties.setProperty("totalQuantity", "AllQuantity");
        properties.setProperty("totalCount", "AllCount");
        properties.setProperty("pulseQuantity", "PulseQuantity");
        properties.setProperty("pulseLockTime", "PulseLockTime");
        properties.setProperty("upperLimit", "UpperLimit");
        properties.setProperty("lowerLimit", "LowerLimit");
        properties.setProperty("customScate", "CustomScate");
        properties.setProperty("firsLockTime", "FirstLockTime");
        properties.setProperty("addValidTime", "AddTrueFrequency");
        properties.setProperty("runState", "RunState");
        properties.setProperty("bufState1", "BUFState1");
        properties.setProperty("bufState2", "BUFState2");
        properties.setProperty("bufState3", "BUFState3");
        properties.setProperty("bufState4", "BUFState4");
        properties.setProperty("bufState5", "BUFState5");
        properties.setProperty("bufState6", "BUFState6");
        properties.setProperty("bufState7", "BUFState7");
        properties.setProperty("bufState8", "BUFState8");
        properties.setProperty("bufState9", "BUFState9");
        properties.setProperty("score", "Score");
        properties.setProperty("addCycle", "FilingCycle");
        properties.setProperty("reduceCycle", "ReductionPeriod");
        properties.setProperty("callFlag", "CallFlag");
        properties.setProperty("startTime", "StartTime");
        properties.setProperty("isRemove", "Visible");
        properties.setProperty("stateFlag", "StateFlag");
        properties.setProperty("noSignal", "NoSignal");
        properties.setProperty("viewState", "ViewState");
        properties.setProperty("remark", "Remark");
        properties.setProperty("lastUploadTime", "LastUploadTime");
        properties.setProperty("gmtModified", "#");
        properties.setProperty("id", "#");
        properties.setProperty("gmtCreate", "#");
        properties.setProperty("isFamily", "#");
        entityProperties.put(BusPumpEntity.class.getSimpleName(), properties);
    }

    private static void registerPatient() {
        Properties properties = new Properties();
        properties.setProperty("patientId", "Patient_ID");
        properties.setProperty("hospitalCode", "SysHospital_ID");
        properties.setProperty("productCode", "SysProduct_ID");
        properties.setProperty("patientCode", "PatientCode");
        properties.setProperty("pumpCode", "PumpCode");
        properties.setProperty("name", "Name");
        properties.setProperty("sex", "Sex");
        properties.setProperty("weight", "Weight");
        properties.setProperty("age", "Age");
        properties.setProperty("wardCode", "Ward");
        properties.setProperty("bedCode", "BedNo");
        properties.setProperty("operationName", "Operation");
        properties.setProperty("operationDoctor", "Surgeon");
        properties.setProperty("asa", "ASA");
        properties.setProperty("easyMode", "EaseMode");
        properties.setProperty("anesthesiaDoctor1", "AnesthesiaMode");
        properties.setProperty("anesthesiaDoctor2", "DoctorTwo");
        properties.setProperty("anesthesiaMode", "AnesthesiaMode");
        properties.setProperty("configPerson", "ConfigPerson");
        properties.setProperty("formula", "Formula");
        properties.setProperty("undoPerson", "UndoPerson");
        properties.setProperty("destoryPerson", "DestroyPerson");
        properties.setProperty("witnessPerson", "WitnessPerson");
        properties.setProperty("undoTime", "UndoTime");
        properties.setProperty("salt", "Salt");
        properties.setProperty("remain", "Balance");
        properties.setProperty("remark", "Remark");
        properties.setProperty("isDelete", "IsDelete");
        properties.setProperty("gmtModified", "#");
        properties.setProperty("id", "#");
        properties.setProperty("gmtCreate", "#");
        entityProperties.put(BusPatientEntity.class.getSimpleName(), properties);
    }

    private static void registerHospital() {
        Properties properties = new Properties();
        properties.setProperty("hospitalCode", "HospitalNumber");
        properties.setProperty("hospitalAddress", "Hospital_Address");
        properties.setProperty("hosptialName", "Name");
        properties.setProperty("provinceCode", "ProvinceCode");
        properties.setProperty("cityCode", "CityCode");
        properties.setProperty("areaCode", "AreaCode");
        properties.setProperty("bodyCode", "BodyCode");
        properties.setProperty("zipCode", "ZipCode");
        properties.setProperty("fax", "Fax");
        properties.setProperty("telephone", "Telephone");
        properties.setProperty("email", "Email");
        properties.setProperty("softwareVersion", "SoftwareVersion");
        properties.setProperty("softwareType", "SoftType");
        properties.setProperty("hardwareVersion", "BaseStationVersion");
        properties.setProperty("hardwareType", "#");
        properties.setProperty("ip", "IPAddress");
        properties.setProperty("gmtModified", "#");
        properties.setProperty("id", "#");
        properties.setProperty("gmtCreate", "#");
        entityProperties.put(BusHospitalEntity.class.getSimpleName(), properties);
    }

    private static void registerAnalgesicScore() {
        Properties properties = new Properties();
        properties.setProperty("pumpCode", "PumpCode");
        properties.setProperty("patientId", "Patient_ID");
        properties.setProperty("hospitalCode", "SysHospital_ID");
        properties.setProperty("productCode", "SysProduct_ID");
        properties.setProperty("statics", "Static");
        properties.setProperty("activity", "Activity");
        properties.setProperty("calm", "Calm");
        properties.setProperty("leftLeg", "LeftLeg");
        properties.setProperty("rightLeg", "RightLeg");
        properties.setProperty("leftArm", "LeftArm");
        properties.setProperty("rightArm", "RightArm");
        properties.setProperty("nauseaVomit", "Nausea_Vomit");
        properties.setProperty("itch", "Itch");
        properties.setProperty("vertigo", "Vertigo");
        properties.setProperty("soreThroat", "SoreThroat");
        properties.setProperty("uroschesis", "Uroschesis");
        properties.setProperty("breathDepression", "BreathDepression");
        properties.setProperty("hoarseness", "Hoarseness");
        properties.setProperty("cognitionObstacle", "Cognition_Obstacle");
        properties.setProperty("other", "Other");
        properties.setProperty("satisfaction", "Satisfaction");
        properties.setProperty("creator", "FollowUp");
        properties.setProperty("followDate", "BillDate");
        properties.setProperty("gmtModified", "#");
        properties.setProperty("analgesicScoreId", "AnalgesicScore_ID");
        properties.setProperty("gmtCreate", "#");
        properties.setProperty("id", "#");
        entityProperties.put(BusAnalgesicScoreEntity.class.getSimpleName(), properties);
    }

    public static JSON convert(Object jsonStr, Class entity, ConverterType converterType) {
        JSONObject jsonObject = (JSONObject)JSON.toJSON((Object)jsonStr);
        String entityName = entity.getSimpleName();
        switch (converterType) {
            case Cloud2PC: {
                ConverterUtils.Cloud2PC((JSONObject)jsonObject.get((Object)"data"), entityName);
                break;
            }
            case PC2Cloud: {
                ConverterUtils.PC2Cloud((JSONObject)jsonObject.get((Object)"data"), entityName);
                break;
            }
        }
        return jsonObject;
    }

    private static void PC2Cloud(JSONObject jsonObject, String entityName) {
        Properties properties = entityProperties.get(entityName);
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(newFiled, oldFiled) -> {
            if (!newFiled.equals("#") && !oldFiled.equals("#") && jsonObject.containsKey(oldFiled)) {
                Object value = jsonObject.get(oldFiled);
                jsonObject.remove(oldFiled);
                jsonObject.put((String)newFiled, value);
            }
        }));
    }

    private static void Cloud2PC(JSONObject jsonObject, String entityName) {
        Properties properties = entityProperties.get(entityName);
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(newFiled, oldFiled) -> {
            if (!newFiled.equals("#") && !oldFiled.equals("#")) {
                if (jsonObject.containsKey(newFiled)) {
                    Object value = jsonObject.get(newFiled);
                    jsonObject.remove(newFiled);
                    jsonObject.put((String)oldFiled, value);
                }
            } else if (jsonObject.containsKey(newFiled)) {
                jsonObject.remove(newFiled);
            }
        }));
    }

    static {
        ConverterUtils.registerAnalgesicScore();
        ConverterUtils.registerHospital();
        ConverterUtils.registerPatient();
        ConverterUtils.registerPump();
    }

    public static enum ConverterType {
        PC2Cloud,
        Cloud2PC;

    }
}

